/*
* motorpwmpot.pde
*
* Hace girar un motor de CC mediante un L293 conectado a los pines digitales
* 7 y 8 controlando la velocidad por PWM sobre el pin Enable del L293 en base
* a la lectura de un potenciometro conectado al pin analogico 2
* 
* Basado en un cdigo de: Miguel Grassi
* www.miguelgrassi.com.ar
*
* Modificado por: V. Garca  el 07.02.2011
*  
*/
int ledPin =  13;    // LED conectado al pin digital 13

int pinA1 = 7; // entrada Motor A 1
int pinB1 = 8; // entrada Motor B 1
int pinEN1 = 9; // entrada EN 1
int pinPot = 2;    // Lectura analgica del Potenciometro
int valorPot= 0;
int valorVeloc = 0;

void setup() {    // Inicializa los pines de salida
  pinMode(ledPin, OUTPUT);     
  pinMode( pinA1, OUTPUT);     
  pinMode( pinB1, OUTPUT);     
  pinMode(pinEN1, OUTPUT);     
  pinMode(pinPot, INPUT);  
  digitalWrite(pinEN1, HIGH);  // linea es la clave, RPA
  Serial.begin(9600);  
// El LED parpadea 3 veces. Esto debera ocurrir slo una vez. 
// Si usted ve el parpadeo del LED tres veces, significa que 
// se restablecio (reset) el propio mdulo. Probablemente porque 
// el motor provoc una bajada de voltaje o un corto.  
  blink(ledPin, 3, 100);  
}

void loop() { 

  digitalWrite( pinA1, HIGH);     // Valores ALTO en A y BAJO en B simulaneamente
  digitalWrite( pinB1, LOW);      // hacen girar el motor 1 hacia ADELANTE
  valorPot = analogRead(pinPot);  // Lee el valor del potenciometro
  valorVeloc =  map(valorPot, 0, 1023, 55, 255); //Convierte un valor entre 0 y 1023 al rango 0-255
//  valorVeloc = valorPot / 4 ;  //  segunda opcin
  analogWrite(pinEN1, valorVeloc);    // y establece la velocidad del motor con ese valor

}
/*  blinks an LED  */
void blink(int whatPin, int cuantoTiempo, int milliSecs) {
  for (int i = 0; i < cuantoTiempo; i++) {
    digitalWrite(whatPin, HIGH);
    delay(milliSecs/2);
    digitalWrite(whatPin, LOW);
    delay(milliSecs/2);
  }
}
