 /* Control de un motor DC con puente H
 *     motorl293h.pde
 * 
 * http://itp.nyu.edu/physcomp/Labs/DCMotorControl
 * 
 * Modificado por V. Garcia el 08.02.2011
 * 
 * Puede adaptarse a un bot con un motor en las ruedas de traccion
 * y una rueda de giro libre que pivote cambiando la direccion 
 */
int switchPin = 2;    // switch input
int motor1Pin = 7;    // H-bridge leg 1 
int motor2Pin = 8;    // H-bridge leg 2 
int speedPin = 9;     // H-bridge enable pin 
int ledPin = 13;      //LED 

void setup() {
  // set the switch as an input:
  pinMode(switchPin, INPUT); 
  digitalWrite(switchPin, HIGH); 
  // set all the other pins you're using as outputs:
  pinMode(motor1Pin, OUTPUT); 
  pinMode(motor2Pin, OUTPUT); 
  pinMode(speedPin, OUTPUT);
  pinMode(ledPin, OUTPUT);
  
  // set speedPin high so that motor can turn on:
  digitalWrite(speedPin, HIGH); 

// El LED parpadea 3 veces. Esto debera ocurrir slo una vez. 
// Si usted ve el parpadeo del LED tres veces, significa que 
// se restablecio (reset) el propio mdulo. Probablemente porque 
// el motor provoc una bajada de voltaje o un corto.  
  blink(ledPin, 3, 100);
}

void loop() {
  // si el switch es high, motor gira en una direccion
  if (digitalRead(switchPin) == HIGH) {
    digitalWrite(motor1Pin, LOW);   // pone motor1 del H-bridge low
    digitalWrite(motor2Pin, HIGH);  // pone motor2 del H-bridge high
  } 
  // si el switch es low, motor gira en la otra direccion:
  else {
    digitalWrite(motor1Pin, HIGH);  // set leg 1 of the H-bridge high
    digitalWrite(motor2Pin, LOW);   // set leg 2 of the H-bridge low
    blink(switchPin, 2000, 2);   // si pulsas switch cambia giro un tiempo
  }
}

/*  blinks an LED  */
void blink(int whatPin, int cuantoTiempo, int milliSecs) {
  int i = 0;
  for ( i = 0; i < cuantoTiempo; i++) {
    digitalWrite(whatPin, HIGH);
    delay(milliSecs/2);
    digitalWrite(whatPin, LOW);
    delay(milliSecs/2);
  }
}
